/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.fabric.network;

import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.fabric.network.ServerNetwork;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.jetbrains.annotations.Nullable;

public class ClientNetworkInstance
extends AbstractNetworkInstance
implements C2SPlayChannelEvents.Register,
ClientPlayConnectionEvents.Disconnect {
    private int remoteVersion = 0;
    public static ClientNetworkInstance networkInstance = new ClientNetworkInstance();
    private boolean disableNBS = false;

    public void init() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> ClientPlayNetworking.registerReceiver((class_2960)ServerNetwork.channelID, this::receiveMessage));
        C2SPlayChannelEvents.REGISTER.register((Object)this);
        ClientPlayConnectionEvents.DISCONNECT.register((Object)this);
    }

    public void onChannelRegister(class_634 handler, PacketSender sender, class_310 client, List<class_2960> channels) {
        if (channels.contains(ServerNetwork.channelID)) {
            this.sendConfigCallback();
            EmoteInstance.instance.getLogger().log(Level.INFO, "Sending presence to server");
        }
    }

    public void onPlayDisconnect(class_634 handler, class_310 client) {
        this.disconnect();
    }

    void receiveMessage(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        if (buf.isDirect() || buf.isReadOnly()) {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), bytes);
            this.receiveMessage(bytes);
        } else {
            this.receiveMessage(buf.array());
        }
    }

    @Override
    public HashMap<Byte, Byte> getVersions() {
        if (this.disableNBS) {
            HashMap<Byte, Byte> map = new HashMap<Byte, Byte>();
            map.put((byte)3, (byte)0);
            return map;
        }
        return null;
    }

    @Override
    public void setVersions(HashMap<Byte, Byte> map) {
        if (map.containsKey((byte)3)) {
            boolean bl = this.disableNBS = map.get((byte)3) == 0;
        }
        if (map.containsKey((byte)8)) {
            this.remoteVersion = map.get((byte)8).byteValue();
        }
    }

    @Override
    public boolean sendPlayerID() {
        return false;
    }

    @Override
    public boolean isActive() {
        return ClientPlayNetworking.canSend((class_2960)ServerNetwork.channelID);
    }

    @Override
    public int getRemoteVersion() {
        return this.remoteVersion;
    }

    @Override
    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        if (target != null) {
            builder.configureTarget(target);
        }
        EmotePacket writer = builder.build();
        ClientPlayNetworking.send((class_2960)ServerNetwork.channelID, (class_2540)new class_2540(Unpooled.wrappedBuffer((byte[])writer.write().array())));
        if (writer.data.emoteData != null && writer.data.emoteData.song != null && !writer.data.writeSong) {
            EmoteInstance.instance.getClientMethods().sendChatMessage(EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.song_too_big_to_send"));
        }
    }
}

